/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_7923;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.dynamic.EnchantmentModifier;
import slimeknights.tconstruct.library.modifiers.hook.HarvestEnchantmentsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.RawDataModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.JsonUtils;
import slimeknights.tconstruct.library.utils.RestrictedCompoundTag;

public abstract class EnchantmentModule
implements ModifierModule {
    protected final class_1887 enchantment;
    protected final int level;

    public EnchantmentModule(class_1887 enchantment, int level) {
        this.enchantment = enchantment;
        this.level = level;
    }

    public static class Constant
    extends EnchantmentModule
    implements RawDataModifierHook {
        private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.RAW_DATA);
        public static final Loader<Constant> LOADER = new Loader<Constant>(Constant::new);

        public Constant(class_1887 enchantment, int level) {
            super(enchantment, level);
        }

        public Constant(class_1887 enchantment) {
            this(enchantment, 1);
        }

        @Override
        public void addRawData(IToolStackView tool, ModifierEntry modifier, RestrictedCompoundTag tag) {
            EnchantmentModifier.addEnchantmentData(tag, this.enchantment, modifier.getLevel() * this.level);
        }

        @Override
        public void removeRawData(IToolStackView tool, Modifier modifier, RestrictedCompoundTag tag) {
            EnchantmentModifier.removeEnchantmentData(tag, this.enchantment);
        }

        @Override
        public List<ModifierHook<?>> getDefaultHooks() {
            return DEFAULT_HOOKS;
        }

        public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
            return LOADER;
        }
    }

    public static class Harvest
    extends EnchantmentModule
    implements HarvestEnchantmentsModifierHook {
        private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.TOOL_HARVEST_ENCHANTMENTS, TinkerHooks.LEGGINGS_HARVEST_ENCHANTMENTS);
        public static final Loader<Harvest> LOADER = new Loader<Harvest>(Harvest::new);

        public Harvest(class_1887 enchantment, int level) {
            super(enchantment, level);
        }

        public Harvest(class_1887 enchantment) {
            this(enchantment, 1);
        }

        @Override
        public void applyHarvestEnchantments(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context, BiConsumer<class_1887, Integer> consumer) {
            consumer.accept(this.enchantment, this.level * modifier.getLevel());
        }

        @Override
        public List<ModifierHook<?>> getDefaultHooks() {
            return DEFAULT_HOOKS;
        }

        public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
            return LOADER;
        }
    }

    public record Loader<T extends EnchantmentModule>(BiFunction<class_1887, Integer, T> constructor) implements GenericLoaderRegistry.IGenericLoader<T>
    {
        public T deserialize(JsonObject json) {
            class_1887 enchantment = (class_1887)JsonHelper.getAsEntry((class_2378)class_7923.field_41176, (JsonObject)json, (String)"name");
            int level = JsonUtils.getIntMin(json, "level", 1);
            return (T)((EnchantmentModule)this.constructor.apply(enchantment, level));
        }

        public void serialize(T object, JsonObject json) {
            json.addProperty("name", Objects.requireNonNull(class_7923.field_41176.method_10221((Object)((EnchantmentModule)object).enchantment)).toString());
            json.addProperty("level", (Number)((EnchantmentModule)object).level);
        }

        public T fromNetwork(class_2540 buffer) {
            class_1887 enchantment = (class_1887)class_7923.field_41176.method_10200(buffer.method_10816());
            int level = buffer.method_10816();
            return (T)((EnchantmentModule)this.constructor.apply(enchantment, level));
        }

        public void toNetwork(T object, class_2540 buffer) {
            buffer.method_10804(class_7923.field_41176.method_10206((Object)((EnchantmentModule)object).enchantment));
            buffer.method_10804(((EnchantmentModule)object).level);
        }
    }
}

